# MediaCrawlerPro 整体架构文档

## ⚠️ 重要声明

**本项目仅供学习和研究目的使用**，使用者应严格遵守以下原则：

1. **不得用于任何商业用途**
2. 使用时应遵守目标平台的使用条款和robots.txt规则
3. 不得进行大规模爬取或对平台造成运营干扰
4. 应合理控制请求频率，避免给目标平台带来不必要的负担
5. 不得用于任何非法或不当的用途

详细许可条款请参阅项目根目录下的 [LICENSE](../LICENSE) 文件。使用本代码即表示您同意遵守上述原则和LICENSE中的所有条款。

---

## 1. 系统概述

MediaCrawlerPro是一个基于Python的多平台社交媒体数据采集系统，支持小红书(XHS)、微博(Weibo)、抖音(Douyin)、快手(Kuaishou)、哔哩哔哩(Bilibili)、百度贴吧(Tieba)、知乎(Zhihu)等主流平台。

系统采用模块化设计，具有高度的可扩展性和可维护性，专为**教育学习**和**技术研究**目的而开发。

## 2. 整体架构图

```mermaid
graph TB
    subgraph "MediaCrawlerPro 主服务"
        A[main.py 启动入口] --> B[CrawlerFactory 爬虫工厂]
        B --> C{选择平台}
        C --> D[XHS爬虫]
        C --> E[Weibo爬虫]
        C --> F[Douyin爬虫]
        C --> G[其他平台爬虫]
    end
    
    subgraph "核心组件层"
        D --> H[Handler处理器]
        D --> I[Client HTTP客户端]
        D --> J[Processor数据处理器]
    end
    
    subgraph "基础设施层"
        K[账号池管理<br/>account_pool/]
        L[代理IP池<br/>proxy/]
        M[缓存系统<br/>cache/]
        N[签名服务客户端<br/>sign_srv_client/]
        O[存储层<br/>repo/]
    end
    
    subgraph "外部服务"
        P[MediaCrawlerPro-SignSrv<br/>签名服务]
        Q[MySQL数据库]
        R[Redis缓存]
    end
    
    H --> K
    H --> L
    I --> M
    I --> N
    J --> O
    
    N --> P
    O --> Q
    M --> R
    K --> Q
```

## 3. 核心架构层级

### 3.1 应用层 (Application Layer)

```mermaid
graph LR
    A[main.py] --> B[CrawlerFactory]
    B --> C[AbstractCrawler]
    C --> D[Platform Crawler<br/>XHS/Weibo/Douyin等]
    
    subgraph "爬虫类型"
        E[Search 搜索]
        F[Detail 详情]
        G[Creator 创作者]
        H[Homefeed 首页推荐]
    end
    
    D --> E
    D --> F
    D --> G
    D --> H
```

**核心组件：**
- `main.py`: 系统启动入口，负责初始化配置和启动爬虫
- `CrawlerFactory`: 工厂模式，根据平台类型创建相应的爬虫实例
- `AbstractCrawler`: 抽象基类，定义了所有爬虫的通用接口

### 3.2 业务逻辑层 (Business Logic Layer)

```mermaid
graph TB
    subgraph "平台特定实现"
        A[Platform Core] --> B[Client HTTP客户端]
        A --> C[Handlers 处理器]
        A --> D[Processors 数据处理器]
    end
    
    subgraph "Handler处理器类型"
        E[SearchHandler<br/>搜索处理]
        F[DetailHandler<br/>详情处理]
        G[CreatorHandler<br/>创作者处理]
        H[HomefeedHandler<br/>首页处理]
    end
    
    subgraph "Processor处理器类型"
        I[NoteProcessor<br/>帖子处理]
        J[CommentProcessor<br/>评论处理]
        K[VideoProcessor<br/>视频处理]
    end
    
    C --> E
    C --> F
    C --> G
    C --> H
    
    D --> I
    D --> J
    D --> K
```

**核心职责：**
- **Client**: 负责HTTP请求的发送和响应处理
- **Handler**: 处理不同类型的爬取任务（搜索、详情、创作者、首页）
- **Processor**: 处理爬取到的数据，进行清洗、转换和存储

### 3.3 基础设施层 (Infrastructure Layer)

#### 3.3.1 账号池管理系统

```mermaid
graph TB
    A[AccountWithIpPoolManager<br/>账号池管理器] --> B{账号存储类型}
    B --> C[Excel文件存储<br/>accounts_cookies.xlsx]
    B --> D[MySQL数据库存储<br/>cookies_manage_sql]
    
    A --> E[账号状态管理]
    A --> F[IP代理配对]
    A --> G[负载均衡]
    
    subgraph "账号状态"
        H[正常 NORMAL]
        I[已封禁 BANNED]
        J[异常 ABNORMAL]
    end
    
    E --> H
    E --> I
    E --> J
```

**功能特性：**
- 支持多账号轮询使用，降低封号风险
- 账号与IP代理一对一绑定，保证请求的一致性
- 实时状态监控，自动处理异常账号

#### 3.3.2 代理IP池系统

```mermaid
graph TB
    A[ProxyIpPool<br/>代理IP池] --> B[代理提供商]
    B --> C[快代理 KuaiDL]
    B --> D[其他代理商]
    
    A --> E[IP状态监控]
    A --> F[自动轮换机制]
    A --> G[连接测试]
    
    subgraph "IP状态管理"
        H[可用 AVAILABLE]
        I[失效 INVALID]
        J[限流 RATE_LIMITED]
    end
    
    E --> H
    E --> I
    E --> J
```

#### 3.3.3 缓存系统

```mermaid
graph TB
    A[CacheFactory<br/>缓存工厂] --> B{缓存类型选择}
    B --> C[LocalCache<br/>本地缓存]
    B --> D[RedisCache<br/>Redis缓存]
    
    subgraph "缓存用途"
        E[请求响应缓存]
        F[用户信息缓存]
        G[配置信息缓存]
    end
    
    C --> E
    C --> F
    C --> G
    D --> E
    D --> F
    D --> G
```

#### 3.3.4 签名服务客户端

```mermaid
graph TB
    A[SignClient<br/>签名客户端] --> B[MediaCrawlerPro-SignSrv<br/>签名服务]
    
    subgraph "签名请求类型"
        C[XhsSignRequest<br/>小红书签名]
        D[DouyinSignRequest<br/>抖音签名]
        E[BilibiliSignRequest<br/>B站签名]
        F[ZhihuSignRequest<br/>知乎签名]
    end
    
    A --> C
    A --> D
    A --> E
    A --> F
    
    B --> G[生成签名参数]
    B --> H[返回签名结果]
```

**服务解耦：**
- 将签名生成逻辑从主服务中抽离
- 支持多语言客户端接入
- 提高系统的可维护性和扩展性

### 3.4 数据持久化层 (Data Persistence Layer)

```mermaid
graph TB
    A[存储层 repo/] --> B{存储方式选择}
    B --> C[数据库存储 DB]
    B --> D[CSV文件存储]
    B --> E[JSON文件存储]
    
    subgraph "数据库存储结构"
        F[平台特定表结构]
        G[xhs_notes 小红书帖子]
        H[weibo_notes 微博帖子]
        I[douyin_awemes 抖音视频]
        J[comments 评论数据]
    end
    
    C --> F
    F --> G
    F --> H
    F --> I
    F --> J
    
    subgraph "存储实现"
        K[StoreImpl 存储实现]
        L[StoreSQL SQL操作]
        M[数据去重机制]
    end
    
    C --> K
    K --> L
    K --> M
```

## 4. 数据流架构

```mermaid
sequenceDiagram
    participant U as 用户
    participant M as Main启动器
    participant C as 爬虫实例
    participant A as 账号池
    participant P as 代理池
    participant S as 签名服务
    participant H as Handler处理器
    participant D as 数据存储
    
    U->>M: 启动爬虫命令
    M->>C: 创建平台爬虫
    C->>A: 获取可用账号
    A->>P: 获取绑定代理IP
    P-->>A: 返回代理信息
    A-->>C: 返回账号+IP对
    
    C->>H: 执行爬取任务
    H->>S: 请求签名参数
    S-->>H: 返回签名结果
    H->>H: 发起HTTP请求
    H->>D: 存储爬取数据
    D-->>H: 确认存储成功
    H-->>C: 返回处理结果
    C-->>U: 显示爬取结果
```

## 5. 配置管理架构

```mermaid
graph TB
    A[配置管理 config/] --> B[base_config.py<br/>基础配置]
    A --> C[db_config.py<br/>数据库配置]
    A --> D[proxy_config.py<br/>代理配置]
    A --> E[sign_srv_config.py<br/>签名服务配置]
    
    subgraph "配置内容"
        F[平台选择 PLATFORM]
        G[搜索关键词 KEYWORDS]
        H[爬取类型 CRAWLER_TYPE]
        I[存储方式 SAVE_DATA_OPTION]
        J[并发控制 MAX_CONCURRENCY_NUM]
    end
    
    B --> F
    B --> G
    B --> H
    B --> I
    B --> J
```

## 6. 断点续爬系统

```mermaid
graph TB
    A[CheckpointManager<br/>断点管理器] --> B[CheckpointStore<br/>断点存储]
    B --> C[data/checkpoints/<br/>断点文件]
    
    A --> D[保存爬取进度]
    A --> E[恢复中断任务]
    A --> F[任务状态跟踪]
    
    subgraph "断点信息"
        G[爬取平台信息]
        H[当前页码]
        I[已爬取数量]
        J[搜索关键词]
        K[时间戳]
    end
    
    D --> G
    D --> H
    D --> I
    D --> J
    D --> K
```

## 7. 系统特性

### 7.1 可扩展性
- **平台扩展**: 通过继承AbstractCrawler轻松添加新平台支持
- **存储扩展**: 支持多种数据存储方式，易于扩展新的存储后端
- **缓存扩展**: 通过CacheFactory模式支持多种缓存实现

### 7.2 容错性
- **账号轮换**: 自动处理账号封禁，切换备用账号
- **重试机制**: 内置请求重试和错误处理机制
- **断点续爬**: 支持任务中断后从上次位置继续

### 7.3 性能优化
- **并发控制**: 可配置的并发爬取数量
- **缓存策略**: 多层缓存减少重复请求
- **连接池**: HTTP连接复用提高请求效率

## 8. 部署架构

```mermaid
graph TB
    subgraph "本地部署"
        A[MediaCrawlerPro-Python<br/>主爬虫服务]
        B[MediaCrawlerPro-SignSrv<br/>签名服务]
        C[MySQL数据库]
        D[Redis缓存]
    end
    
    A --> B
    A --> C
    A --> D

```

## 9. 安全与合规

### 9.1 请求频率控制
- 内置请求间隔控制，避免对目标平台造成压力
- 可配置的并发数量限制
- 基于平台特性的自适应频率调整

### 9.2 数据合规
- 仅爬取公开信息，不涉及隐私数据
- 遵循各平台的robots.txt规则

### 9.3 使用限制
- **严禁商业用途**: 仅限学习和研究使用
- **频率限制**: 必须合理控制请求频率
- **平台规则**: 必须遵守目标平台使用条款

---

## 总结

MediaCrawlerPro采用分层架构设计，通过模块化的组件组织，实现了高度的可维护性和可扩展性。系统严格遵循**仅供学习使用**的原则，在技术实现上注重性能优化和容错处理，为学习者提供了一个优秀的爬虫技术研究平台。

**请务必遵守LICENSE协议，仅将本项目用于学习和研究目的，不得用于任何商业用途或对平台造成不当影响的行为。**