# 声明：本代码仅供学习和研究目的使用。使用者应遵守以下原则：  
# 1. 不得用于任何商业用途。  
# 2. 使用时应遵守目标平台的使用条款和robots.txt规则。  
# 3. 不得进行大规模爬取或对平台造成运营干扰。  
# 4. 应合理控制请求频率，避免给目标平台带来不必要的负担。   
# 5. 不得用于任何非法或不当的用途。
#   
# 详细许可条款请参阅项目根目录下的LICENSE文件。  
# 使用本代码即表示您同意遵守上述原则和LICENSE中的所有条款。  


# -*- coding: utf-8 -*-
# @Author  : relakkes@gmail.com
# @Time    : 2024/4/5 10:18
# @Desc    : 基础类型
import time
from enum import Enum
from typing import Dict, Optional

from pydantic import BaseModel, Field


class ProviderNameEnum(Enum):
    JISHU_HTTP_PROVIDER: str = "jishuhttp"
    KUAI_DAILI_PROVIDER: str = "kuaidaili"


class IpInfoModel(BaseModel):
    """Unified IP model"""
    ip: str = Field(title="ip")
    port: int = Field(title="端口")
    user: str = Field(title="IP代理认证的用户名")
    protocol: str = Field(default="https://", title="代理IP的协议")
    password: str = Field(title="IP代理认证用户的密码")
    expired_time_ts: int = Field(title="IP过期时间时间戳，单位秒")

    def format_httpx_proxy(self) -> Dict:
        """
        Get the httpx proxy dict
        Returns:

        """
        httpx_proxy = {
            f"{self.protocol}": f"http://{self.user}:{self.password}@{self.ip}:{self.port}"
        }
        return httpx_proxy

    @property
    def is_expired(self) -> bool:
        """
        Check if the IP is expired
        Returns:
            bool: True if the IP is expired, False otherwise
        """
        return self.expired_time_ts < int(time.time())