/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.server.startup.BootFailureException;
import org.neo4j.server.startup.BootloaderContext;
import org.neo4j.server.startup.MacBootloaderOs;
import org.neo4j.server.startup.ProcessManager;
import org.neo4j.server.startup.UnixBootloaderOs;
import org.neo4j.server.startup.WindowsBootloaderOs;

abstract class BootloaderOsAbstraction {
    static final long UNKNOWN_PID = Long.MAX_VALUE;
    protected final BootloaderContext ctx;

    protected BootloaderOsAbstraction(BootloaderContext ctx) {
        this.ctx = ctx;
    }

    abstract Long getPidIfRunning();

    abstract boolean isRunning(long var1);

    abstract long start() throws BootFailureException;

    abstract void stop(long var1) throws BootFailureException;

    long console() throws BootFailureException {
        return this.ctx.processManager().run(this.buildStandardStartArguments(), this.consoleBehaviour());
    }

    protected ProcessManager.Behaviour consoleBehaviour() {
        return ProcessManager.behaviour().blocking().inheritIO().withShutdownHook();
    }

    long admin() throws BootFailureException {
        MutableList arguments = this.buildBaseArguments();
        if (this.ctx.getEnv("HEAP_SIZE").isBlank()) {
            arguments = arguments.reject((Predicate & Serializable)argument -> argument.startsWith("-Xms"));
        }
        return this.ctx.processManager().run((List<String>)arguments.withAll(this.ctx.additionalArgs), ProcessManager.behaviour().blocking().inheritIO().homeAndConfAsEnv());
    }

    abstract void installService() throws BootFailureException;

    abstract void uninstallService() throws BootFailureException;

    abstract void updateService() throws BootFailureException;

    abstract boolean serviceInstalled();

    protected List<String> buildStandardStartArguments() {
        return this.buildBaseArguments().with((Object)("--home-dir=" + String.valueOf(this.ctx.home()))).with((Object)("--config-dir=" + String.valueOf(this.ctx.confDir()))).withAll(this.ctx.additionalArgs);
    }

    private MutableList<String> buildBaseArguments() {
        return Lists.mutable.with((Object[])new String[]{this.getJavaCmd()}).with((Object)"-cp").with((Object)this.getClassPath()).withAll(this.getJvmOpts()).with((Object)this.ctx.entrypoint.getName());
    }

    static BootloaderOsAbstraction getOsAbstraction(BootloaderContext context) {
        return SystemUtils.IS_OS_WINDOWS ? new WindowsBootloaderOs(context) : (SystemUtils.IS_OS_MAC_OSX ? new MacBootloaderOs(context) : new UnixBootloaderOs(context));
    }

    protected static String executeCommand(String[] command) {
        Process process = null;
        try {
            process = new ProcessBuilder(command).start();
            if (!process.waitFor(30L, TimeUnit.SECONDS)) {
                throw new IllegalStateException(String.format("Timed out executing command `%s`", String.join((CharSequence)" ", command)));
            }
            String output = StringUtils.trimToEmpty((String)new String(process.getInputStream().readAllBytes()));
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                String errOutput = new String(process.getErrorStream().readAllBytes());
                throw new IllegalStateException(String.format("Command `%s` failed with exit code %s.%n%s%n%s", String.join((CharSequence)" ", command), exitCode, output, errOutput));
            }
            String string = output;
            return string;
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    protected String getJavaCmd() {
        Path java = BootloaderOsAbstraction.getJava();
        this.checkJavaVersion();
        return java.toString();
    }

    private void printBadRuntime() {
        this.ctx.err.println("WARNING! You are using an unsupported Java runtime.");
        this.ctx.err.println("* Please use Oracle(R) Java(TM) 11, OpenJDK(TM) 11 to run Neo4j.");
        this.ctx.err.println("* Please see https://neo4j.com/docs/ for Neo4j installation instructions.");
    }

    private static Path getJava() {
        Optional<String> currentCommand = ProcessHandle.current().info().command();
        return Path.of(currentCommand.orElseThrow(() -> new IllegalStateException("Wasn't able to figure out java binary")), new String[0]);
    }

    private void checkJavaVersion() {
        if (this.ctx.version().feature() != 11) {
            this.printBadRuntime();
        } else {
            String runtime = this.ctx.getProp("java.vm.name");
            if (!runtime.matches("(Java HotSpot\\(TM\\)|OpenJDK) (64-Bit Server|Server|Client) VM")) {
                this.printBadRuntime();
            }
        }
    }

    private static String bytesToSuitableJvmString(long bytes) {
        return Math.max(bytes / ByteUnit.kibiBytes((long)1L), 1L) + "k";
    }

    protected List<String> getJvmOpts() {
        String envJavaOptions = this.ctx.getEnv("JAVA_OPTS");
        if (StringUtils.isNotEmpty((CharSequence)envJavaOptions)) {
            if (StringUtils.isNotEmpty((CharSequence)this.ctx.getEnv("HEAP_SIZE"))) {
                this.ctx.err.println("WARNING! HEAP_SIZE is ignored, because JAVA_OPTS is set");
            }
            return List.of(((String)SettingValueParsers.JVM_ADDITIONAL.parse(envJavaOptions)).split(System.lineSeparator()));
        }
        return this.buildJvmOpts();
    }

    private List<String> buildJvmOpts() {
        String jvmAdditionals;
        String xmxValue;
        String xmsValue;
        MutableList opts = Lists.mutable.empty();
        String envHeapSize = this.ctx.getEnv("HEAP_SIZE");
        Configuration config = this.ctx.config();
        if (StringUtils.isNotEmpty((CharSequence)envHeapSize)) {
            xmsValue = envHeapSize;
            xmxValue = envHeapSize;
        } else {
            Long xmsConfigValue = (Long)config.get(BootloaderSettings.initial_heap_size);
            Long xmxConfigValue = (Long)config.get(BootloaderSettings.max_heap_size);
            xmsValue = xmsConfigValue != null ? BootloaderOsAbstraction.bytesToSuitableJvmString(xmsConfigValue) : null;
            String string = xmxValue = xmxConfigValue != null ? BootloaderOsAbstraction.bytesToSuitableJvmString(xmxConfigValue) : null;
        }
        if (xmsValue != null) {
            opts.with((Object)("-Xms" + xmsValue));
        }
        if (xmxValue != null) {
            opts.with((Object)("-Xmx" + xmxValue));
        }
        if (StringUtils.isNotEmpty((CharSequence)(jvmAdditionals = (String)config.get(BootloaderSettings.additional_jvm)))) {
            opts.withAll(List.of(jvmAdditionals.split(System.lineSeparator())));
        }
        if (((Boolean)config.get(BootloaderSettings.gc_logging_enabled)).booleanValue()) {
            opts.with((Object)String.format("%s:file=%s::filecount=%s,filesize=%s", config.get(BootloaderSettings.gc_logging_options), ((Path)config.get(GraphDatabaseSettings.logs_directory)).resolve("gc.log"), config.get(BootloaderSettings.gc_logging_rotation_keep_number), BootloaderOsAbstraction.bytesToSuitableJvmString((Long)config.get(BootloaderSettings.gc_logging_rotation_size))));
        }
        opts.with((Object)"-Dfile.encoding=UTF-8");
        return opts;
    }

    protected String getClassPath() {
        String libCp = BootloaderOsAbstraction.classPathFromDir((Path)this.ctx.config().get(BootloaderSettings.lib_directory));
        MutableList paths = Lists.mutable.with((Object[])new String[]{BootloaderOsAbstraction.classPathFromDir((Path)this.ctx.config().get(GraphDatabaseSettings.plugin_dir)), BootloaderOsAbstraction.classPathFromDir(this.ctx.confDir()), StringUtils.isNotBlank((CharSequence)libCp) ? libCp : this.ctx.getProp("java.class.path")});
        return paths.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(File.pathSeparator));
    }

    private static String classPathFromDir(Path dir) {
        try {
            if (Files.isDirectory(dir, new LinkOption[0]) && !FileUtils.isDirectoryEmpty((Path)dir)) {
                return String.valueOf(dir.toAbsolutePath()) + File.separator + "*";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

