/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.server.startup.BootFailureException;
import org.neo4j.server.startup.BootProcessFailureException;
import org.neo4j.server.startup.BootloaderContext;
import org.neo4j.server.startup.PidFileHelper;
import sun.misc.Signal;

class ProcessManager {
    private final BootloaderContext ctx;

    static Behaviour behaviour() {
        return new Behaviour();
    }

    ProcessManager(BootloaderContext ctx) {
        this.ctx = ctx;
    }

    long run(List<String> command, Behaviour behaviour) throws BootFailureException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (behaviour.inheritIO) {
            processBuilder.inheritIO();
        }
        if (behaviour.redirectToUserLog) {
            File userLog = ((Path)this.ctx.config().get(GraphDatabaseSettings.store_user_log_path)).toFile();
            try {
                FileUtils.writeToFile((Path)userLog.toPath(), (String)"", (boolean)true);
            }
            catch (IOException e) {
                throw new BootFailureException("Failure to create the user log file " + String.valueOf(userLog) + " due to " + e.getMessage(), 1);
            }
            ProcessBuilder.Redirect redirect = ProcessBuilder.Redirect.appendTo(userLog);
            processBuilder.redirectOutput(redirect);
            processBuilder.redirectError(redirect);
        }
        if (behaviour.homeAndConfAsEnv) {
            Map<String, String> env = processBuilder.environment();
            env.putIfAbsent("NEO4J_HOME", this.ctx.home().toString());
            env.putIfAbsent("NEO4J_CONF", this.ctx.confDir().toString());
        }
        Process process = null;
        try {
            if (this.ctx.verbose) {
                this.ctx.out.println("Executing command line: " + String.join((CharSequence)" ", command));
            }
            process = processBuilder.start();
            if (behaviour.shutdownHook) {
                this.installShutdownHook(process);
            }
            if (behaviour.storePid) {
                this.storePid(process.pid(), behaviour.throwOnStorePidFailure);
            }
            if (behaviour.blocking) {
                process.waitFor();
            } else {
                process.waitFor(this.ctx.getEnv("NEO4J_START_WAIT", 0, SettingValueParsers.INT).intValue(), TimeUnit.SECONDS);
            }
            if (!process.isAlive()) {
                if (!behaviour.inheritIO) {
                    PrintStream out = behaviour.outputConsumer != null ? behaviour.outputConsumer : this.ctx.out;
                    PrintStream err = behaviour.errorConsumer != null ? behaviour.errorConsumer : this.ctx.err;
                    out.write(process.getInputStream().readAllBytes());
                    err.write(process.getErrorStream().readAllBytes());
                }
                if (process.exitValue() != 0) {
                    throw new BootProcessFailureException(process.exitValue());
                }
            }
            return process.pid();
        }
        catch (BootFailureException e) {
            throw e;
        }
        catch (Exception e) {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            throw new BootFailureException("Unexpected error while starting. Aborting. " + e.getClass().getSimpleName() + " : " + e.getMessage(), e);
        }
    }

    private void installShutdownHook(Process finalProcess) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.killProcess(finalProcess)));
        Runnable onSignal = () -> System.exit(this.killProcess(finalProcess));
        ProcessManager.installSignal("INT", onSignal);
        ProcessManager.installSignal("TERM", onSignal);
    }

    private static void installSignal(String signal, Runnable onExit) {
        try {
            Signal.handle(new Signal(signal), s -> onExit.run());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private synchronized int killProcess(Process finalProcess) {
        if (finalProcess.isAlive()) {
            finalProcess.destroy();
            while (finalProcess.isAlive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        this.deletePid();
        return finalProcess.exitValue();
    }

    Long getPidFromFile() {
        Path pidFile = this.pidFile();
        try {
            return PidFileHelper.readPid(pidFile);
        }
        catch (AccessDeniedException e) {
            throw new BootFailureException("Access denied reading pid file " + String.valueOf(pidFile), 1);
        }
        catch (IOException e) {
            throw new BootFailureException("Unexpected error reading pid file " + String.valueOf(pidFile), 1, e);
        }
    }

    ProcessHandle getProcessHandle(long pid) throws BootFailureException {
        Optional<ProcessHandle> handleOption = ProcessHandle.of(pid);
        if (handleOption.isEmpty() || !handleOption.get().isAlive()) {
            this.deletePid();
            return null;
        }
        return handleOption.get();
    }

    private void deletePid() {
        PidFileHelper.remove(this.pidFile());
    }

    private void storePid(long pid, boolean throwOnFailure) throws IOException {
        Path pidFilePath = this.pidFile();
        try {
            PidFileHelper.storePid(this.pidFile(), pid);
        }
        catch (AccessDeniedException exception) {
            if (throwOnFailure) {
                throw exception;
            }
            this.ctx.err.printf("Failed to write PID file: Access denied at %s%n", pidFilePath.toAbsolutePath());
        }
    }

    private Path pidFile() {
        return (Path)this.ctx.config().get(BootloaderSettings.pid_file);
    }

    static class Behaviour {
        protected boolean inheritIO;
        protected boolean blocking;
        protected boolean redirectToUserLog;
        protected boolean storePid;
        protected boolean throwOnStorePidFailure;
        protected boolean homeAndConfAsEnv;
        protected boolean shutdownHook;
        protected PrintStream outputConsumer;
        protected PrintStream errorConsumer;

        Behaviour() {
        }

        Behaviour inheritIO() {
            this.inheritIO = true;
            return this;
        }

        Behaviour blocking() {
            this.blocking = true;
            return this;
        }

        Behaviour withShutdownHook() {
            this.shutdownHook = true;
            return this;
        }

        Behaviour redirectToUserLog() {
            this.redirectToUserLog = true;
            return this;
        }

        Behaviour storePid() {
            this.storePid = true;
            this.throwOnStorePidFailure = true;
            return this;
        }

        Behaviour tryStorePid() {
            this.storePid = true;
            this.throwOnStorePidFailure = false;
            return this;
        }

        Behaviour outputConsumer(PrintStream stream) {
            this.outputConsumer = stream;
            return this;
        }

        Behaviour errorConsumer(PrintStream stream) {
            this.errorConsumer = stream;
            return this;
        }

        Behaviour homeAndConfAsEnv() {
            this.homeAndConfAsEnv = true;
            return this;
        }
    }
}

