/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltQueryExecutor;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltResultHandle;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.impl.AbstractTransactionStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.impl.BoltAdapterSubscriber;
import org.neo4j.bolt.v3.runtime.CypherAdapterStreamV3;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class TransactionStateMachineV3SPI
extends AbstractTransactionStateMachineSPI {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionStateMachineV3SPI.class);

    public TransactionStateMachineV3SPI(BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI, BoltChannel boltChannel, SystemNanoClock clock, StatementProcessorReleaseManager resourceReleaseManager, String transactionId) {
        super(boltGraphDatabaseServiceSPI, boltChannel, clock, resourceReleaseManager, transactionId);
    }

    @Override
    public BoltTransaction beginTransaction(KernelTransaction.Type transactionType, LoginContext loginContext, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, RoutingContext routingContext) {
        TransactionStateMachineV3SPI.checkBookmarks(bookmarks);
        return super.beginTransaction(transactionType, loginContext, bookmarks, txTimeout, accessMode, txMetadata, routingContext);
    }

    @Override
    protected BoltResultHandle newBoltResultHandle(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
        return new BoltResultHandleV3(statement, params, boltQueryExecutor);
    }

    private static void checkBookmarks(List<Bookmark> bookmarks) {
        if (!bookmarks.isEmpty() && bookmarks.size() != 1) {
            throw new IllegalArgumentException("Expected zero or one bookmark. Received: " + String.valueOf(bookmarks));
        }
    }

    private class BoltResultHandleV3
    extends AbstractTransactionStateMachineSPI.AbstractBoltResultHandle {
        BoltResultHandleV3(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
            super(statement, params, boltQueryExecutor);
        }

        @Override
        protected BoltResult newBoltResult(QueryExecution result, BoltAdapterSubscriber subscriber, Clock clock) {
            return new CypherAdapterStreamV3(result, subscriber, clock);
        }
    }
}

