/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v44;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.routing.ProcedureRoutingTableGetter;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.impl.AbstractBoltStateMachine;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v4.runtime.AutoCommitState;
import org.neo4j.bolt.v41.runtime.ConnectedState;
import org.neo4j.bolt.v43.runtime.FailedState;
import org.neo4j.bolt.v44.runtime.InTransactionState;
import org.neo4j.bolt.v44.runtime.ReadyState;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.MapValue;

public class BoltStateMachineV44
extends AbstractBoltStateMachine {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltStateMachineV44.class);

    public BoltStateMachineV44(BoltStateMachineSPI boltSPI, BoltChannel boltChannel, Clock clock, DefaultDatabaseResolver defaultDatabaseResolver, MapValue connectionHints, MemoryTracker memoryTracker, TransactionManager transactionManager) {
        super(boltSPI, boltChannel, clock, defaultDatabaseResolver, connectionHints, memoryTracker, transactionManager);
    }

    @Override
    protected AbstractBoltStateMachine.States buildStates(MapValue connectionHints, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(ConnectedState.SHALLOW_SIZE + ReadyState.SHALLOW_SIZE + AutoCommitState.SHALLOW_SIZE + InTransactionState.SHALLOW_SIZE + FailedState.SHALLOW_SIZE + InterruptedState.SHALLOW_SIZE);
        ConnectedState connected = new ConnectedState(connectionHints);
        AutoCommitState autoCommitState = new AutoCommitState();
        InTransactionState inTransaction = new InTransactionState();
        FailedState failed = new FailedState();
        ReadyState ready = new ReadyState(new ProcedureRoutingTableGetter());
        InterruptedState interrupted = new InterruptedState();
        connected.setReadyState(ready);
        ready.setTransactionReadyState(inTransaction);
        ready.setStreamingState(autoCommitState);
        ready.setFailedState(failed);
        ready.setInterruptedState(interrupted);
        autoCommitState.setReadyState(ready);
        autoCommitState.setFailedState(failed);
        autoCommitState.setInterruptedState(interrupted);
        inTransaction.setReadyState(ready);
        inTransaction.setFailedState(failed);
        inTransaction.setInterruptedState(interrupted);
        failed.setInterruptedState(interrupted);
        interrupted.setReadyState(ready);
        return new AbstractBoltStateMachine.States(connected, failed);
    }
}

