/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryPool;
import org.neo4j.util.Preconditions;

class MemoryPoolImpl
implements MemoryPool {
    private final AtomicLong maxMemory = new AtomicLong();
    private final AtomicLong usedHeapBytes = new AtomicLong();
    private final AtomicLong usedNativeBytes = new AtomicLong();
    private final boolean strict;
    private final String limitSettingName;

    MemoryPoolImpl(long limit, boolean strict, String limitSettingName) {
        this.limitSettingName = limitSettingName;
        this.maxMemory.set(MemoryPoolImpl.validateSize(limit));
        this.strict = strict;
    }

    @Override
    public long usedHeap() {
        return this.usedHeapBytes.get();
    }

    @Override
    public long usedNative() {
        return this.usedNativeBytes.get();
    }

    @Override
    public long free() {
        return Math.max(0L, this.totalSize() - this.totalUsed());
    }

    @Override
    public void releaseHeap(long bytes) {
        this.usedHeapBytes.addAndGet(-bytes);
    }

    @Override
    public void releaseNative(long bytes) {
        this.usedNativeBytes.addAndGet(-bytes);
    }

    @Override
    public void reserveHeap(long bytes) {
        this.reserveMemory(bytes, this.usedHeapBytes);
    }

    @Override
    public void reserveNative(long bytes) {
        this.reserveMemory(bytes, this.usedNativeBytes);
    }

    private void reserveMemory(long bytes, AtomicLong counter) {
        long usedMemoryBefore;
        do {
            long max = this.maxMemory.get();
            usedMemoryBefore = counter.get();
            if (!this.strict || this.totalUsed() + bytes <= max) continue;
            throw new MemoryLimitExceededException(bytes, max, this.totalUsed(), Status.General.MemoryPoolOutOfMemoryError, this.limitSettingName);
        } while (!counter.weakCompareAndSetVolatile(usedMemoryBefore, usedMemoryBefore + bytes));
    }

    @Override
    public long totalSize() {
        return this.maxMemory.get();
    }

    @Override
    public void setSize(long size) {
        this.maxMemory.set(MemoryPoolImpl.validateSize(size));
    }

    private static long validateSize(long size) {
        if (size == 0L) {
            return Long.MAX_VALUE;
        }
        return Preconditions.requirePositive(size);
    }
}

