/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.io.Serializable;
import java.net.URI;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.messages.MessageUtil;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class RemoteUrlValidator$ {
    public static RemoteUrlValidator$ MODULE$;

    static {
        new RemoteUrlValidator$();
    }

    public Option<Throwable> assertValidRemoteDatabaseUrl(String url, boolean secure) {
        None$ none$;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (url == null || url.isEmpty()) {
                throw new InvalidArgumentException("The provided url is empty.");
            }
            String uriScheme = URI.create(url).getScheme();
            Seq validSchemes = (Seq)new .colon.colon((Object)"neo4j", (List)new .colon.colon((Object)"neo4j+s", (List)new .colon.colon((Object)"neo4j+ssc", (List)Nil$.MODULE$)));
            if (uriScheme == null || !validSchemes.contains((Object)uriScheme)) {
                throw new InvalidArgumentException(MessageUtil.invalidScheme((String)url, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(validSchemes).asJava())));
            }
            if (secure && !uriScheme.endsWith("+s") && !uriScheme.endsWith("+ssc")) {
                Seq secureSchemes = (Seq)new .colon.colon((Object)"neo4j+s", (List)new .colon.colon((Object)"neo4j+ssc", (List)Nil$.MODULE$));
                throw new InvalidArgumentException(MessageUtil.insecureScheme((String)url, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(secureSchemes).asJava())));
            }
        });
        if (try_ instanceof Success) {
            none$ = None$.MODULE$;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            none$ = new Some((Object)e);
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    private RemoteUrlValidator$() {
        MODULE$ = this;
    }
}

