/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.OptionalLong;
import java.util.StringJoiner;
import java.util.function.Function;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.procedure.builtin.BuiltInProcedures;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Value;

public final class SchemaStatementProcedure {
    private static final String CREATE_UNIQUE_PROPERTY_CONSTRAINT = "CALL db.createUniquePropertyConstraint( '%s', %s, %s, '%s', %s )";
    private static final String CREATE_NODE_KEY_CONSTRAINT = "CALL db.createNodeKey( '%s', %s, %s, '%s', %s )";
    private static final String CREATE_NODE_EXISTENCE_CONSTRAINT = "CREATE CONSTRAINT `%s` ON (a:`%s`) ASSERT (a.`%s`) IS NOT NULL";
    private static final String CREATE_RELATIONSHIP_EXISTENCE_CONSTRAINT = "CREATE CONSTRAINT `%s` ON ()-[a:`%s`]-() ASSERT (a.`%s`) IS NOT NULL";
    private static final String CREATE_BTREE_INDEX = "CALL db.createIndex('%s', %s, %s, '%s', %s)";
    private static final String CREATE_NODE_FULLTEXT_INDEX = "CALL db.index.fulltext.createNodeIndex('%s', %s, %s, %s)";
    private static final String CREATE_RELATIONSHIP_FULLTEXT_INDEX = "CALL db.index.fulltext.createRelationshipIndex('%s', %s, %s, %s)";
    private static final String DROP_CONSTRAINT = "DROP CONSTRAINT `%s`";
    private static final String DROP_INDEX = "DROP INDEX `%s`";
    private static final String SINGLE_CONFIG = "`%s`: %s";

    private SchemaStatementProcedure() {
    }

    static Collection<BuiltInProcedures.SchemaStatementResult> createSchemaStatementResults(SchemaReadCore schemaRead, TokenRead tokenRead) throws ProcedureException {
        HashMap<String, BuiltInProcedures.SchemaStatementResult> schemaStatements = new HashMap<String, BuiltInProcedures.SchemaStatementResult>();
        Iterator allIndexes = schemaRead.indexesGetAll();
        while (allIndexes.hasNext()) {
            IndexDescriptor index = (IndexDescriptor)allIndexes.next();
            if (!SchemaStatementProcedure.includeIndex(schemaRead, index)) continue;
            String name = index.getName();
            String type = SchemaRuleType.INDEX.name();
            String createStatement = SchemaStatementProcedure.createStatement(tokenRead, index);
            String dropStatement = SchemaStatementProcedure.dropStatement(index);
            schemaStatements.put(name, new BuiltInProcedures.SchemaStatementResult(name, type, createStatement, dropStatement));
        }
        Iterator allConstraints = schemaRead.constraintsGetAll();
        while (allConstraints.hasNext()) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)allConstraints.next();
            if (!SchemaStatementProcedure.includeConstraint(schemaRead, constraint)) continue;
            String name = constraint.getName();
            String type = SchemaRuleType.CONSTRAINT.name();
            String createStatement = SchemaStatementProcedure.createStatement(arg_0 -> ((SchemaReadCore)schemaRead).indexGetForName(arg_0), tokenRead, constraint);
            String dropStatement = SchemaStatementProcedure.dropStatement(constraint);
            schemaStatements.put(name, new BuiltInProcedures.SchemaStatementResult(name, type, createStatement, dropStatement));
        }
        return schemaStatements.values();
    }

    private static boolean includeConstraint(SchemaReadCore schemaRead, ConstraintDescriptor constraint) {
        if (constraint.isIndexBackedConstraint()) {
            IndexDescriptor backingIndex;
            IndexBackedConstraintDescriptor indexBackedConstraint = constraint.asIndexBackedConstraint();
            if (indexBackedConstraint.indexType() == IndexType.BTREE && indexBackedConstraint.hasOwnedIndexId() && (backingIndex = schemaRead.indexGetForName(constraint.getName())).getId() == indexBackedConstraint.ownedIndexId()) {
                try {
                    InternalIndexState internalIndexState = schemaRead.indexGetState(backingIndex);
                    OptionalLong owningConstraintId = backingIndex.getOwningConstraintId();
                    return internalIndexState == InternalIndexState.ONLINE && owningConstraintId.orElse(-1L) == constraint.getId();
                }
                catch (IndexNotFoundKernelException e) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean includeIndex(SchemaReadCore schemaRead, IndexDescriptor index) {
        try {
            InternalIndexState indexState = schemaRead.indexGetState(index);
            boolean relationshipPropertyIndex = index.getIndexType().equals((Object)IndexType.BTREE) && index.schema().entityType().equals((Object)EntityType.RELATIONSHIP);
            return indexState == InternalIndexState.ONLINE && !index.isUnique() && !SchemaStatementProcedure.indexHasNewType(index) && !relationshipPropertyIndex;
        }
        catch (IndexNotFoundKernelException e) {
            return false;
        }
    }

    private static boolean indexHasNewType(IndexDescriptor indexDescriptor) {
        IndexType indexType = indexDescriptor.getIndexType();
        return indexType != IndexType.BTREE && indexType != IndexType.FULLTEXT;
    }

    public static String createStatement(Function<String, IndexDescriptor> indexLookup, TokenRead tokenRead, ConstraintDescriptor constraint) throws ProcedureException {
        try {
            String property;
            String name = constraint.getName();
            if (constraint.isIndexBackedConstraint()) {
                String labelsOrRelTypes = SchemaStatementProcedure.labelsOrRelTypesAsStringArray(tokenRead, constraint.schema());
                String properties = SchemaStatementProcedure.propertiesAsStringArray(tokenRead, constraint.schema());
                IndexDescriptor backingIndex = indexLookup.apply(name);
                String providerName = backingIndex.getIndexProvider().name();
                String config = SchemaStatementProcedure.btreeConfigAsString(backingIndex);
                if (constraint.isUniquenessConstraint()) {
                    return String.format(CREATE_UNIQUE_PROPERTY_CONSTRAINT, name, labelsOrRelTypes, properties, providerName, config);
                }
                if (constraint.isNodeKeyConstraint()) {
                    return String.format(CREATE_NODE_KEY_CONSTRAINT, name, labelsOrRelTypes, properties, providerName, config);
                }
            }
            if (constraint.isNodePropertyExistenceConstraint()) {
                int labelId = constraint.schema().getLabelId();
                String label = tokenRead.nodeLabelName(labelId);
                int propertyId = constraint.schema().getPropertyId();
                property = tokenRead.propertyKeyName(propertyId);
                return String.format(CREATE_NODE_EXISTENCE_CONSTRAINT, SchemaStatementProcedure.escapeBackticks(name), SchemaStatementProcedure.escapeBackticks(label), SchemaStatementProcedure.escapeBackticks(property));
            }
            if (constraint.isRelationshipPropertyExistenceConstraint()) {
                int relationshipTypeId = constraint.schema().getRelTypeId();
                String relationshipType = tokenRead.relationshipTypeName(relationshipTypeId);
                int propertyId = constraint.schema().getPropertyId();
                property = tokenRead.propertyKeyName(propertyId);
                return String.format(CREATE_RELATIONSHIP_EXISTENCE_CONSTRAINT, SchemaStatementProcedure.escapeBackticks(name), SchemaStatementProcedure.escapeBackticks(relationshipType), SchemaStatementProcedure.escapeBackticks(property));
            }
            throw new IllegalArgumentException("Did not recognize constraint type " + String.valueOf(constraint));
        }
        catch (KernelException e) {
            throw new ProcedureException((Status)Status.General.UnknownError, (Throwable)e, "Failed to re-create create statement.", new Object[0]);
        }
    }

    private static String dropStatement(ConstraintDescriptor constraint) {
        return String.format(DROP_CONSTRAINT, SchemaStatementProcedure.escapeBackticks(constraint.getName()));
    }

    public static String createStatement(TokenRead tokenRead, IndexDescriptor indexDescriptor) throws ProcedureException {
        try {
            String name = indexDescriptor.getName();
            String labelsOrRelTypes = SchemaStatementProcedure.labelsOrRelTypesAsStringArray(tokenRead, indexDescriptor.schema());
            String properties = SchemaStatementProcedure.propertiesAsStringArray(tokenRead, indexDescriptor.schema());
            switch (indexDescriptor.getIndexType()) {
                case BTREE: {
                    String btreeConfig = SchemaStatementProcedure.btreeConfigAsString(indexDescriptor);
                    String providerName = indexDescriptor.getIndexProvider().name();
                    return String.format(CREATE_BTREE_INDEX, name, labelsOrRelTypes, properties, providerName, btreeConfig);
                }
                case FULLTEXT: {
                    String fulltextConfig = SchemaStatementProcedure.fulltextConfigAsString(indexDescriptor);
                    switch (indexDescriptor.schema().entityType()) {
                        case NODE: {
                            return String.format(CREATE_NODE_FULLTEXT_INDEX, name, labelsOrRelTypes, properties, fulltextConfig);
                        }
                        case RELATIONSHIP: {
                            return String.format(CREATE_RELATIONSHIP_FULLTEXT_INDEX, name, labelsOrRelTypes, properties, fulltextConfig);
                        }
                    }
                    throw new IllegalArgumentException("Did not recognize entity type " + String.valueOf(indexDescriptor.schema().entityType()));
                }
            }
            throw new IllegalArgumentException("Did not recognize index type " + String.valueOf(indexDescriptor.getIndexType()));
        }
        catch (KernelException e) {
            throw new ProcedureException((Status)Status.General.UnknownError, (Throwable)e, "Failed to re-create create statement.", new Object[0]);
        }
    }

    private static String btreeConfigAsString(IndexDescriptor indexDescriptor) {
        IndexConfig indexConfig = indexDescriptor.getIndexConfig();
        StringJoiner configString = SchemaStatementProcedure.configStringJoiner();
        for (Pair entry : indexConfig.entries()) {
            String singleConfig = String.format(SINGLE_CONFIG, entry.getOne(), SchemaStatementProcedure.btreeConfigValueAsString((Value)entry.getTwo()));
            configString.add(singleConfig);
        }
        return configString.toString();
    }

    private static String btreeConfigValueAsString(Value configValue) {
        if (configValue instanceof DoubleArray) {
            DoubleArray doubleArray = (DoubleArray)configValue;
            return Arrays.toString(doubleArray.asObjectCopy());
        }
        if (configValue instanceof IntValue) {
            IntValue intValue = (IntValue)configValue;
            return "" + intValue.value();
        }
        if (configValue instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)configValue;
            return "" + booleanValue.booleanValue();
        }
        if (configValue instanceof StringValue) {
            StringValue stringValue = (StringValue)configValue;
            return "'" + stringValue.stringValue() + "'";
        }
        throw new IllegalArgumentException("Could not convert config value '" + String.valueOf(configValue) + "' to config string.");
    }

    private static String fulltextConfigAsString(IndexDescriptor indexDescriptor) {
        IndexConfig indexConfig = indexDescriptor.getIndexConfig();
        StringJoiner configString = SchemaStatementProcedure.configStringJoiner();
        for (Pair entry : indexConfig.entries()) {
            String key = (String)entry.getOne();
            String singleConfig = String.format(SINGLE_CONFIG, key, SchemaStatementProcedure.fulltextConfigValueAsString((Value)entry.getTwo()));
            configString.add(singleConfig);
        }
        return configString.toString();
    }

    private static String fulltextConfigValueAsString(Value configValue) {
        if (configValue instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)configValue;
            return "'" + booleanValue.booleanValue() + "'";
        }
        if (configValue instanceof StringValue) {
            StringValue stringValue = (StringValue)configValue;
            return "'" + stringValue.stringValue() + "'";
        }
        throw new IllegalArgumentException("Could not convert config value '" + String.valueOf(configValue) + "' to config string.");
    }

    private static String propertiesAsStringArray(TokenRead tokenRead, SchemaDescriptor schema) throws PropertyKeyIdNotFoundKernelException {
        StringJoiner properties = SchemaStatementProcedure.arrayStringJoiner();
        for (int propertyId : schema.getPropertyIds()) {
            properties.add("'" + tokenRead.propertyKeyName(propertyId) + "'");
        }
        return properties.toString();
    }

    private static String labelsOrRelTypesAsStringArray(TokenRead tokenRead, SchemaDescriptor schema) throws KernelException {
        StringJoiner labelsOrRelTypes = SchemaStatementProcedure.arrayStringJoiner();
        for (int entityTokenId : schema.getEntityTokenIds()) {
            if (EntityType.NODE.equals((Object)schema.entityType())) {
                labelsOrRelTypes.add("'" + tokenRead.nodeLabelName(entityTokenId) + "'");
                continue;
            }
            labelsOrRelTypes.add("'" + tokenRead.relationshipTypeName(entityTokenId) + "'");
        }
        return labelsOrRelTypes.toString();
    }

    private static String dropStatement(IndexDescriptor indexDescriptor) {
        return String.format(DROP_INDEX, SchemaStatementProcedure.escapeBackticks(indexDescriptor.getName()));
    }

    private static StringJoiner configStringJoiner() {
        return new StringJoiner(",", "{", "}");
    }

    private static StringJoiner arrayStringJoiner() {
        return new StringJoiner(", ", "[", "]");
    }

    private static String escapeBackticks(String str) {
        return str.replaceAll("`", "``");
    }

    static enum SchemaRuleType {
        INDEX,
        CONSTRAINT;

    }
}

