/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.Optional;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.procedure.builtin.routing.DatabaseAvailabilityChecker;

public final class DefaultDatabaseAvailabilityChecker
implements DatabaseAvailabilityChecker {
    private final DatabaseManager<?> databaseManager;

    public DefaultDatabaseAvailabilityChecker(DatabaseManager<?> databaseManager) {
        this.databaseManager = databaseManager;
    }

    @Override
    public boolean isAvailable(DatabaseReference.Internal databaseReference) {
        Optional databaseCtx = this.databaseManager.getDatabaseContext(databaseReference.databaseId());
        return databaseCtx.map(ctx -> ctx.database().getDatabaseAvailabilityGuard().isAvailable()).orElse(false);
    }

    @Override
    public boolean isPresent(DatabaseReference.Internal databaseReference) {
        return this.databaseManager.getDatabaseContext(databaseReference.databaseId()).isPresent();
    }
}

