/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.function.Function;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFacade;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.util.IdGeneratorUpdatesWorkSync;
import org.neo4j.storageengine.util.IdUpdateListener;

public class TransactionApplierFactoryChain
implements TransactionApplierFactory {
    private final Function<IdGeneratorUpdatesWorkSync, IdUpdateListener> idUpdateListenerFunction;
    private final TransactionApplierFactory[] appliers;

    public TransactionApplierFactoryChain(Function<IdGeneratorUpdatesWorkSync, IdUpdateListener> idUpdateListenerFunction, TransactionApplierFactory ... appliers) {
        this.idUpdateListenerFunction = idUpdateListenerFunction;
        this.appliers = appliers;
    }

    public IdUpdateListener getIdUpdateListener(IdGeneratorUpdatesWorkSync idGeneratorUpdatesWorkSync) {
        return this.idUpdateListenerFunction.apply(idGeneratorUpdatesWorkSync);
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction, BatchContext batchContext) throws IOException {
        TransactionApplier[] txAppliers = new TransactionApplier[this.appliers.length];
        for (int i = 0; i < this.appliers.length; ++i) {
            txAppliers[i] = this.appliers[i].startTx(transaction, batchContext);
        }
        return new TransactionApplierFacade(txAppliers);
    }
}

