/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaRuleMapifier;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.ConstantIntStoreHeaderFormat;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.IntStoreHeaderFormat;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordStorageCapability;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;

public class SchemaStore
extends CommonAbstractStore<SchemaRecord, IntStoreHeader> {
    private static final IntStoreHeaderFormat VALID_STORE_HEADER = new IntStoreHeaderFormat(0);
    private static final IntStoreHeaderFormat DISABLED_STORE_HEADER = new ConstantIntStoreHeaderFormat(0);
    public static final String TYPE_DESCRIPTOR = "SchemaStore";
    private final PropertyStore propertyStore;

    public SchemaStore(Path path, Path idFile, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, PropertyStore propertyStore, RecordFormats recordFormats, DatabaseReadOnlyChecker readOnlyChecker, String databaseName, ImmutableSet<OpenOption> openOptions) {
        super(path, idFile, conf, idType, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormats.schema(), SchemaStore.getStoreHeaderFormat(recordFormats), recordFormats.storeVersion(), readOnlyChecker, databaseName, openOptions);
        this.propertyStore = propertyStore;
    }

    private static IntStoreHeaderFormat getStoreHeaderFormat(RecordFormats recordFormats) {
        return recordFormats.hasCapability(RecordStorageCapability.FLEXIBLE_SCHEMA_STORE) ? VALID_STORE_HEADER : DISABLED_STORE_HEADER;
    }

    public PropertyStore propertyStore() {
        return this.propertyStore;
    }

    public static int getOwningConstraintPropertyKeyId(TokenHolders tokenHolders) throws KernelException {
        int[] ids = new int[1];
        tokenHolders.propertyKeyTokens().getOrCreateInternalIds(new String[]{"__org.neo4j.SchemaRule.owningConstraint"}, ids);
        return ids[0];
    }

    public static SchemaRule readSchemaRule(SchemaRecord record, PropertyStore propertyStore, TokenHolders tokenHolders, StoreCursors storeCursors) throws MalformedSchemaRuleException {
        Map<String, Value> map = SchemaStore.schemaRecordToMap(record, propertyStore, tokenHolders, storeCursors);
        return SchemaRuleMapifier.unmapifySchemaRule((long)record.getId(), map);
    }

    private static Map<String, Value> schemaRecordToMap(SchemaRecord record, PropertyStore propertyStore, TokenHolders tokenHolders, StoreCursors storeCursors) throws MalformedSchemaRuleException {
        HashMap<String, Value> props = new HashMap<String, Value>();
        PropertyRecord propRecord = propertyStore.newRecord();
        long nextProp = record.getNextProp();
        while (nextProp != Record.NO_NEXT_PROPERTY.longValue()) {
            try {
                propertyStore.getRecordByCursor(nextProp, propRecord, RecordLoad.NORMAL, storeCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR));
            }
            catch (InvalidRecordException e) {
                throw new MalformedSchemaRuleException("Cannot read schema rule because it is referencing a property record (id " + nextProp + ") that is invalid: " + String.valueOf(propRecord), (Throwable)((Object)e));
            }
            for (PropertyBlock propertyBlock : propRecord) {
                PropertyKeyValue propertyKeyValue = propertyBlock.newPropertyKeyValue(propertyStore, storeCursors);
                SchemaStore.insertPropertyIntoMap(propertyKeyValue, props, tokenHolders);
            }
            nextProp = propRecord.getNextProp();
        }
        if (props.isEmpty()) {
            IndexDescriptor descriptor = IndexDescriptor.NLI_PROTOTYPE.materialise(record.getId());
            props.putAll(SchemaRuleMapifier.mapifySchemaRule((SchemaRule)descriptor));
        }
        return props;
    }

    private static void insertPropertyIntoMap(PropertyKeyValue propertyKeyValue, Map<String, Value> props, TokenHolders tokenHolders) throws MalformedSchemaRuleException {
        try {
            NamedToken propertyKeyTokenName = tokenHolders.propertyKeyTokens().getInternalTokenById(propertyKeyValue.propertyKeyId());
            props.put(propertyKeyTokenName.name(), propertyKeyValue.value());
        }
        catch (InvalidRecordException | TokenNotFoundException e) {
            int id = propertyKeyValue.propertyKeyId();
            throw new MalformedSchemaRuleException("Cannot read schema rule because it is referring to a property key token (id " + id + ") that does not exist.", (Throwable)e);
        }
    }

    public static IntObjectMap<Value> convertSchemaRuleToMap(SchemaRule rule, TokenHolders tokenHolders) throws KernelException {
        Map stringlyMap = SchemaRuleMapifier.mapifySchemaRule((SchemaRule)rule);
        int size = stringlyMap.size();
        String[] keys = new String[size];
        int[] keyIds = new int[size];
        Value[] values = new Value[size];
        Iterator itr = stringlyMap.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = itr.next();
            keys[i] = (String)entry.getKey();
            values[i] = (Value)entry.getValue();
        }
        tokenHolders.propertyKeyTokens().getOrCreateInternalIds(keys, keyIds);
        IntObjectHashMap tokenisedMap = new IntObjectHashMap();
        for (int i = 0; i < size; ++i) {
            tokenisedMap.put(keyIds[i], (Object)values[i]);
        }
        return tokenisedMap;
    }
}

