/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.standard;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.SchemaRecord;

public class SchemaRecordFormat
extends BaseOneByteHeaderRecordFormat<SchemaRecord>
implements RecordFormat<SchemaRecord> {
    public static final int RECORD_SIZE = 8;
    private static final int HEADER_SHIFT = 56;
    private static final long RECORD_IN_USE_BIT = 0x100000000000000L;
    private static final int HAS_PROP_BIT = 2;
    private static final long RECORD_HAS_PROPERTY = 0x200000000000000L;
    private static final long RECORD_PROPERTY_REFERENCE_MASK = 0xFFFFFFFFFFFFFFL;
    private static final long NO_NEXT_PROP = Record.NO_NEXT_PROPERTY.longValue();

    public SchemaRecordFormat() {
        this(false);
    }

    public SchemaRecordFormat(boolean pageAligned) {
        super(SchemaRecordFormat.fixedRecordSize(8), 0, 1, 32, pageAligned);
    }

    @Override
    public SchemaRecord newRecord() {
        return new SchemaRecord(-1L);
    }

    @Override
    public void read(SchemaRecord record, PageCursor cursor, RecordLoad mode, int recordSize, int recordsPerPage) throws IOException {
        long data = cursor.getLong();
        boolean inUse = (data & 0x100000000000000L) != 0L;
        boolean shouldLoad = mode.shouldLoad(inUse);
        boolean hasProperty = (data & 0x200000000000000L) == 0x200000000000000L;
        record.initialize(inUse, shouldLoad && hasProperty ? data & 0xFFFFFFFFFFFFFFL : NO_NEXT_PROP);
    }

    @Override
    public void write(SchemaRecord record, PageCursor cursor, int recordSize, int recordsPerPage) throws IOException {
        long data = 0L;
        if (record.inUse()) {
            data = 0x100000000000000L;
            long prop = record.getNextProp();
            if (prop != NO_NEXT_PROP) {
                if ((prop & 0xFFFFFFFFFFFFFFL) != prop) {
                    cursor.setCursorException("Property reference value outside of range that can be stored in a schema record: " + prop);
                    return;
                }
                data += 0x200000000000000L | prop;
            }
        }
        cursor.putLong(data);
    }

    @Override
    public boolean isInUse(PageCursor cursor) {
        long data = cursor.getLong();
        return (data & 0x100000000000000L) != 0L;
    }
}

