/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractLogEntry;
import org.neo4j.storageengine.api.Mask;
import org.neo4j.storageengine.api.StoreId;

public class LogEntryDetachedCheckpoint
extends AbstractLogEntry {
    private final LogPosition logPosition;
    private final long checkpointTime;
    private final StoreId storeId;
    private final String reason;

    public LogEntryDetachedCheckpoint(KernelVersion version, LogPosition logPosition, long checkpointMillis, StoreId storeId, String reason) {
        super(version, (byte)8);
        this.logPosition = logPosition;
        this.checkpointTime = checkpointMillis;
        this.storeId = storeId;
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryDetachedCheckpoint that = (LogEntryDetachedCheckpoint)o;
        return Objects.equals(this.logPosition, that.logPosition) && Objects.equals(this.checkpointTime, that.checkpointTime) && Objects.equals(this.storeId, that.storeId) && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.logPosition, this.checkpointTime, this.storeId, this.reason);
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public LogPosition getLogPosition() {
        return this.logPosition;
    }

    @Override
    public String toString(Mask mask) {
        return "LogEntryDetachedCheckpoint{logPosition=" + String.valueOf(this.logPosition) + ", checkpointTime=" + this.checkpointTime + ", storeId=" + String.valueOf(this.storeId) + ", reason='" + this.reason + "'}";
    }
}

